unit Unit1;

interface

{==============================================================================}
{ This demo shows how to use Tags of items in mode when Tags are considered as }
{ pointers to dynamically allocated strings (PChar).                           }
{ In this demo, rvoTagsArePChars was added in Options (IMPORTANT!)             }
{ In this mode, you need to allocate memory for tag strings with StrNew.       }
{ RichView will free this memory itself when needed.                           }
{------------------------------------------------------------------------------}
{ The key methods are the same as in the previous demo.                        }
{ You still can use Add***, which set Tags to 0 (i.e. nil - empty string).     }
{------------------------------------------------------------------------------}
{ This is the most powerful method for organizing hypertext, because you can   }
{ encode any information that you need in string.                              }
{------------------------------------------------------------------------------}
{ IMPORTANT: Do not use #0 in Tag strings (except from the character closing   }
{ the string)                                                                  }
{==============================================================================}

{$I RV_Defs.inc}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  {$IFDEF RICHVIEWDEF4}
  ImgList,
  {$ENDIF}
  RVStyle, ExtCtrls, RVScroll, RichView, CRVFData, SclRView;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    RVStyle1: TRVStyle;
    ImageList1: TImageList;
    Image1: TImage;
    srv: TSRichViewEdit;
    procedure FormCreate(Sender: TObject);
    procedure RichView1Jump(Sender: TObject; id: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
var ico: TIcon;
begin
  srv.SetMargin(5, 5, 5, 5);

  srv.RichViewEdit.AddNL('Some text styles can be chosen as hypertext styles. ',0,0);
  srv.RichViewEdit.AddNLTag('Like this one.',4,-1, Integer(StrNew('First_jump')));
  srv.RichViewEdit.AddNL(' You can have as many hypertext styles as you want.  ',0,-1);
  srv.RichViewEdit.AddNLTag('Here is one more.',5,-1,  Integer(StrNew('Second_jump')));
  srv.RichViewEdit.AddNL('Images from Image Lists also can be hypertext: ',0,0);
  srv.RichViewEdit.AddHotspotExTag('Pen Image', 0,1, ImageList1, -1, Integer(StrNew('Third_jump')));
  srv.RichViewEdit.AddNL(' Such images are called "hotspots".',0,-1);
  ico := TIcon.Create;
  ico.Assign(Image1.Picture.Graphic);
  srv.RichViewEdit.AddHotPictureTag('Bobo', ico, -1, rvvaBaseLine, Integer(StrNew('Fourth_jump')));
  srv.RichViewEdit.Format;
end;

procedure TForm1.RichView1Jump(Sender: TObject; id: Integer);
var ItemNo: Integer;
    RVData: TCustomRVFormattedData;
    Tag: PChar;
begin
  srv.RichViewEdit.GetJumpPointLocation(id, RVData, ItemNo);
  Tag := PChar(RVData.GetItemTag(ItemNo));
  Panel1.Caption := 'Clicked: Item with Tag='+Tag;
end;

end.
